<?php

namespace App\Http\Controllers;

use App\Models\UserModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class userMobileController extends Controller
{

    /**
     * @OA\Post(
     *   path="/api/otp",
     *   tags={"Mobile with customer"},
     *   summary="Generate OTP New User OR Old User",
     *   description="It will return an OTP and customer type",
     *   operationId="otpGeneration",       
     *   @OA\RequestBody(
     *       required=true,
     *       @OA\MediaType(
     *           mediaType="application/json",
     *           @OA\Schema(
     *               @OA\Property(property="mobile", type="string", example="900000"),
     *           )
     *       )
     *   ),
     *   @OA\Response(response=200, description="Successful operation"),
     *   @OA\Response(response=400, description="Bad request"),
     *   @OA\Response(response=401, description="Unauthorized"),
     *   @OA\Response(response=404, description="Not found"),
     *   @OA\Response(response=406, description="Not acceptable"),
     *   @OA\Response(response=422, description="Validation error"),
     *   @OA\Response(response=500, description="Internal server error")
     * )
     *
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function GenerateOTP(Request $request)
    {
        // Validate request data
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|min:9'
        ]);
        // Return errors if validation error occur.
        if ($validator->fails()) {
            $errors = $validator->errors();
            return response()->json([
                'error' => $errors
            ], 400);
        }
        // Check if validation pass then create user and auth token. Return the auth token
        if ($validator->passes()) {
            $mobileExist = UserModel::where('mobile', $request->mobile)->first();
            $response = [];
            $otp = rand(100000, 999999);
            $response['otp_generated_at'] = now();
            $response['otp'] = $otp;
            if (!$mobileExist) { // Check if mobile number exists
                $data = new UserModel(); // Initialize the $data variable with a new instance of UserModel
                $data->mobile = $request->mobile;
                $data->save();
                $response['customer_type'] = 'new';
            }else{
                $response['customer_type'] = 'old';
            }
            return response()->json([
                'data' => @$response,
                'status' => 'OTP send successfully',
            ]);
        }
        
    }

       /**
         * @OA\Post(
         *   path="/api/mobile-otp",
         *   tags={"Mobile with customer"},
         *   summary="To auth the mobile",
         *   description="It will return a booking auth details",
         *   @OA\RequestBody(
         *         @OA\MediaType(
         *          mediaType="application/json",
         *          @OA\Schema(
         *             @OA\Property(property="name", type="string", example="admin1"),
         *             @OA\Property(property="email", type="string", example="admin1@gmail.com"),
         *             @OA\Property(property="mobile", type="string", example="9696969696"),
         *          ),
         *   ),
         * ),
         *   @OA\Response(response=200, description="Successful operation"),
         *   @OA\Response(response=400, description="Bad request"),
         *   @OA\Response(response=401, description="Unauthorized"),
         *   @OA\Response(response=404, description="Not found"),
         *   @OA\Response(response=406, description="Not acceptable"),
         *   @OA\Response(response=422, description="Validation error"),
         *   @OA\Response(response=500, description="Internal server error")
         * )
         * 
         */
    public function verifyMobile(Request $request)
    {  
        if ($request->has('mobile')) { // Check if 'mobile' is present in the request
            $mobileExist = UserModel::where('mobile', $request->mobile)->first(); // Use 'where' instead of 'findOrFail'
        
            if (!$mobileExist) { // Check if mobile number exists
                $data = new UserModel(); // Initialize the $data variable with a new instance of UserModel
        
                $data->name = $request->name;
                $data->email = $request->email;
                $data->mobile = $request->mobile;
                $data->city = 'Chennai';
                $data->save();
                $response = [];
                $otp = rand(100000, 999999);
                $response['name'] = $request->name;
                $response['email'] =  $request->email;
                $data['customer_type'] = 'new';
                $response['otp'] = $otp;
                $response['otp_generated_at'] = now();
                return response()->json([
                    'status' => 'Created and OTP send successfully',
                    'data' => @$response
                ]);
            }
        }
    }

        /**
         * @OA\Post(
         *   path="/api/mobile-otp-old",
         *   tags={"Mobile otp"},
         *   summary="To auth the mobile",
         *   description="It will return a booking auth details",
         *   @OA\RequestBody(
         *         @OA\MediaType(
         *          mediaType="application/json",
         *          @OA\Schema(
         *             @OA\Property(property="mobile", type="string", example="")
         *          ),
         *   ),
         * ),
         *   @OA\Response(response=200, description="Successful operation"),
         *   @OA\Response(response=400, description="Bad request"),
         *   @OA\Response(response=401, description="Unauthorized"),
         *   @OA\Response(response=404, description="Not found"),
         *   @OA\Response(response=406, description="Not acceptable"),
         *   @OA\Response(response=422, description="Validation error"),
         *   @OA\Response(response=500, description="Internal server error")
         * )
         * 
         */
    public function verifyCustomer(Request $request)
    {
        $mobileExist = UserModel::where('mobile', $request->mobile)->first();
        if ($mobileExist) {
            $data = [];
            $otp = rand(100000, 999999);
            $data['otp'] = $otp;
            $data['customer_type'] = 'old';
            $data['otp_generated_at'] = now();
            return response()->json([
                'status' => 'OTP send successfully',
                'data' => @$data
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
