<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->enum('gender', ['male', 'female', 'other']);
            $table->string('email')->nullable();
            $table->string('city')->nullable(); // Set city as nullable
            $table->string('state')->nullable(); // Set state as nullable
            $table->string('country')->nullable(); // Set country as nullable
            $table->text('address')->nullable(); // Set address as nullable
            $table->string('mobile')->unique()->nullable(); // Set mobile as nullable
            $table->string('pincode')->nullable(); // Set pincode as nullable
            $table->date('DOB')->nullable(); // Set DOB as nullable
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user');
    }
};
