<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\CouponModel;

class UsersController extends Controller
{
    
    /**
     * @OA\Get(
     *   path="/api/get-auth-user",
     *   tags={"Users"},
     *   summary="To get the user",
     *   description="It will return a user details",
     *   operationId="get users",
     *   security={{"bearerAuth":{}}},
     * 
     *   @OA\Response(response=200, description="Successful operation"),
     *   @OA\Response(response=400, description="Bad request"),
     *   @OA\Response(response=401, description="Unauthorized"),
     *   @OA\Response(response=404, description="Not found"),
     *   @OA\Response(response=406, description="Not acceptable"),
     *   @OA\Response(response=422, description="Validation error"),
     *   @OA\Response(response=500, description="Internal server error")
     * )
     * 
     */
    public static function getAuthUser (Request $request) 
    {
        return response()->json(Auth::user());
    }


    /**
     * @OA\Post(
     *   path="/api/update-user",
     *   tags={"Users"},
     *   summary="To update user detail",
     *   description="It will success message",
     *   operationId="update user",    
     *   security={{"bearerAuth":{}}},
     *   @OA\RequestBody(
     *       @OA\MediaType(
     *           mediaType="application/json",
     *           @OA\Schema(
     *               @OA\Property(property="name", type="string", example="900000"),
     *               @OA\Property(property="gender", type="string", example="male or female or other"),
     *               @OA\Property(property="city", type="string", example=""),
     *               @OA\Property(property="state", type="string", example=""),
     *               @OA\Property(property="country", type="string", example=""),
     *               @OA\Property(property="address", type="string", example=""),
     *               @OA\Property(property="pincode", type="string", example=""),
     *               @OA\Property(property="dob", type="string", example="YYYY-MM-DD"),
     *               @OA\Property(property="country_code", type="string", example=""),
     *           )
     *       )
     *   ),
     *   @OA\Response(response=200, description="Successful operation"),
     *   @OA\Response(response=400, description="Bad request"),
     *   @OA\Response(response=401, description="Unauthorized"),
     *   @OA\Response(response=404, description="Not found"),
     *   @OA\Response(response=406, description="Not acceptable"),
     *   @OA\Response(response=422, description="Validation error"),
     *   @OA\Response(response=500, description="Internal server error")
     * )
     *
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public static function updateUser (Request $request) 
    {
        $data['status'] = 'User id is must be important';
        $user_id = Auth::user()->id;
        if (@$user_id) {
            User::whereId($user_id)->update($request->all());
            $data['status'] = 'User updated successfully';
        }
        return response()->json($data);
    }


    /**
     * @OA\Post(
     *   path="/api/verify-coupon",
     *   tags={"Coupon"},
     *   summary="To verify coupon",
     *   description="It will coupon data",
     *   operationId="verify-coupon",    
     *   security={{"bearerAuth":{}}},
     *   @OA\RequestBody(
     *       @OA\MediaType(
     *           mediaType="application/json",
     *           @OA\Schema(
     *               @OA\Property(property="coupon_code", type="string", example=""),
     *           )
     *       )
     *   ),
     *   @OA\Response(response=200, description="Successful operation"),
     *   @OA\Response(response=400, description="Bad request"),
     *   @OA\Response(response=401, description="Unauthorized"),
     *   @OA\Response(response=404, description="Not found"),
     *   @OA\Response(response=406, description="Not acceptable"),
     *   @OA\Response(response=422, description="Validation error"),
     *   @OA\Response(response=500, description="Internal server error")
     * )
     *
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public static function verifyCoupon (Request $request) 
    {
        $coupon_model = CouponModel::where('expiry_date', '>=' ,date('Y-m-d'))->where($request->all())->first();
        $data['status'] = 'Invalid coupon code';
        
        if (!@$coupon_model) return response()->json($data);
        
        if (!$coupon_model->is_multiple && $coupon_model->user_count == 0) {
            return response()->json($data);
        }

        if ($coupon_model->is_unique_user) {
            $cust_id = Auth::user()->id;
            $coupon_users = DB::table('coupon_users')->where(['coupon_id' => $coupon_model->id, 'cust_id' => $cust_id])->exists();
            if ($coupon_users) {
                return response()->json($data);
            }
        }

        if (@$coupon_model->percentage) {
            $data['percentage'] = $coupon_model->percentage;
            $data['status'] = 'Valid coupon code';
        } else {
            $data['cash'] = $coupon_model->cash;
            $data['status'] = 'Valid coupon code';
        }
        return response()->json($data);
    }

}