<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupon', function (Blueprint $table) {
            $table->id();
            $table->string('coupon_code')->nullable();
            $table->integer('cash')->nullable();
            $table->string('percentage')->nullable();
            $table->date('expiry_date')->nullable();
            $table->integer('is_multiple')->nullable();
            $table->integer('user_count')->nullable();
            $table->integer('is_unique_user')->nullable();
            $table->integer('type')->nullable();
            $table->integer('min_amount')->nullable();
            $table->timestamps();
        });

        Schema::create('coupon_users', function (Blueprint $table) {
            $table->id();
            $table->integer('coupon_id')->nullable();
            $table->integer('cust_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupon');
        Schema::dropIfExists('coupon_users');
    }
};
